/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/main.ts
var main_exports = {};
__export(main_exports, {
  default: () => ChemicalStructureRendererPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian2 = require("obsidian");

// src/settings-tab.ts
var import_obsidian = require("obsidian");
var ChemicalStructureRendererSettingsTab = class extends import_obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    let { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h2", { text: "Chemical Structure Renderer Plugin Settings" });
    new import_obsidian.Setting(containerEl).setName("Width").setDesc("Set the width of the rendered structure (must be a number!)").addText((text) => text.setPlaceholder("Enter width").setValue(this.plugin.settings.width).onChange(async (value) => {
      this.plugin.settings.width = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Server").setDesc("Set the server to use for rendering").addText((text) => text.setPlaceholder("Enter server URL").setValue(this.plugin.settings.server).onChange(async (value) => {
      this.plugin.settings.server = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian.Setting(containerEl).setName("Image format").setDesc("Choose the format of the rendered image").addDropdown((dropdown) => {
      dropdown.addOption("image/svg;base64", "SVG").addOption("image/png;base64", "PNG").setValue(this.plugin.settings.format).onChange(async (value) => {
        this.plugin.settings.format = value;
        await this.plugin.saveSettings();
      });
    });
  }
};

// src/main.ts
var DEFAULT_SETTINGS = {
  width: "300",
  server: "https://lifescience.opensource.epam.com",
  format: "image/svg;base64"
};
var ChemicalStructureRendererPlugin = class extends import_obsidian2.Plugin {
  async getImage(smiles) {
    const response = await (0, import_obsidian2.requestUrl)({
      url: this.settings.server + "/v2/indigo/render",
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": this.settings.format
      },
      body: JSON.stringify({
        struct: smiles,
        query: "",
        output_format: this.settings.format,
        options: {}
      })
    });
    return response.text;
  }
  async renderImage(smiles, el) {
    try {
      const imageData = await this.getImage(smiles);
      const imgEl = document.createElement("img");
      const mimeType = this.settings.format.replace(";base64", "+xml");
      imgEl.src = `data:${mimeType};base64,${imageData}`;
      imgEl.style.width = this.settings.width + "px";
      imgEl.classList.add("chemical-structure-image");
      el.appendChild(imgEl);
    } catch (error) {
      console.error(`Failed to render SMILES: ${error}`);
    }
  }
  async renderImagesFromCodeBlock(text, el) {
    const smilesList = text.split("\n");
    const containerEl = document.createElement("div");
    containerEl.classList.add("chemical-structure-container");
    for (const smiles of smilesList) {
      if (smiles.trim() !== "") {
        await this.renderImage(smiles, containerEl);
      }
    }
    el.appendChild(containerEl);
  }
  async onload() {
    console.log("loading Chemical Structure Renderer Plugin");
    await this.loadSettings();
    this.addSettingTab(new ChemicalStructureRendererSettingsTab(this.app, this));
    this.registerMarkdownCodeBlockProcessor("smiles", async (source, el, ctx) => {
      const smiles = source.trim();
      await this.renderImagesFromCodeBlock(smiles, el);
    });
    this.registerMarkdownPostProcessor(async (el, ctx) => {
      el.querySelectorAll("code.language-smiles").forEach(async (codeElement) => {
        const smiles = codeElement.textContent || "";
        await this.renderImagesFromCodeBlock(smiles, el);
      });
    });
  }
  onunload() {
    console.log("unloading Chemical Structure Renderer Plugin");
  }
  async loadSettings() {
    this.settings = Object.assign({}, DEFAULT_SETTINGS, await this.loadData());
  }
  async saveSettings() {
    await this.saveData(this.settings);
  }
};
//# sourceMappingURL=data:application/json;base64,ewogICJ2ZXJzaW9uIjogMywKICAic291cmNlcyI6IFsic3JjL21haW4udHMiLCAic3JjL3NldHRpbmdzLXRhYi50cyJdLAogICJzb3VyY2VzQ29udGVudCI6IFsiaW1wb3J0IHsgUGx1Z2luLCByZXF1ZXN0VXJsIH0gZnJvbSAnb2JzaWRpYW4nO1xyXG5cclxuaW1wb3J0IENoZW1pY2FsU3RydWN0dXJlUmVuZGVyZXJTZXR0aW5nc1RhYiAgZnJvbSAnLi9zZXR0aW5ncy10YWInO1xyXG5cclxuaW50ZXJmYWNlIENoZW1pY2FsU3RydWN0dXJlUmVuZGVyZXJTZXR0aW5ncyAge1xyXG4gIHdpZHRoOiBzdHJpbmc7XHJcbiAgc2VydmVyOiBzdHJpbmc7XHJcbiAgZm9ybWF0OiAnaW1hZ2Uvc3ZnO2Jhc2U2NCcgfCAnaW1hZ2UvcG5nO2Jhc2U2NCc7XHJcbn1cclxuXHJcbmNvbnN0IERFRkFVTFRfU0VUVElOR1M6IENoZW1pY2FsU3RydWN0dXJlUmVuZGVyZXJTZXR0aW5ncyAgPSB7XHJcbiAgd2lkdGg6ICczMDAnLFxyXG4gIHNlcnZlcjogJ2h0dHBzOi8vbGlmZXNjaWVuY2Uub3BlbnNvdXJjZS5lcGFtLmNvbScsXHJcbiAgZm9ybWF0OiAnaW1hZ2Uvc3ZnO2Jhc2U2NCcsXHJcbn07XHJcblxyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDaGVtaWNhbFN0cnVjdHVyZVJlbmRlcmVyUGx1Z2luICBleHRlbmRzIFBsdWdpbiB7XHJcbiAgc2V0dGluZ3M6IENoZW1pY2FsU3RydWN0dXJlUmVuZGVyZXJTZXR0aW5ncyA7XHJcblxyXG4gIGFzeW5jIGdldEltYWdlKHNtaWxlczogc3RyaW5nKTogUHJvbWlzZTxzdHJpbmc+IHtcclxuICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgcmVxdWVzdFVybCh7XHJcbiAgICAgIHVybDogdGhpcy5zZXR0aW5ncy5zZXJ2ZXIgKyAnL3YyL2luZGlnby9yZW5kZXInLCBcclxuICAgICAgbWV0aG9kOiBcIlBPU1RcIixcclxuICAgICAgaGVhZGVyczoge1xyXG4gICAgICAgICdDb250ZW50LVR5cGUnOiAnYXBwbGljYXRpb24vanNvbicsXHJcbiAgICAgICAgJ0FjY2VwdCc6IHRoaXMuc2V0dGluZ3MuZm9ybWF0LFxyXG4gICAgICB9LFxyXG4gICAgICBib2R5OiBKU09OLnN0cmluZ2lmeSh7XHJcbiAgICAgICAgc3RydWN0OiBzbWlsZXMsXHJcbiAgICAgICAgcXVlcnk6ICcnLFxyXG4gICAgICAgIG91dHB1dF9mb3JtYXQ6IHRoaXMuc2V0dGluZ3MuZm9ybWF0LFxyXG4gICAgICAgIG9wdGlvbnM6IHt9XHJcbiAgICAgIH0pLFxyXG4gICAgfSk7XHJcblxyXG4gICAgcmV0dXJuIHJlc3BvbnNlLnRleHQ7XHJcbiAgfVxyXG5cclxuICBhc3luYyByZW5kZXJJbWFnZShzbWlsZXM6IHN0cmluZywgZWw6IEhUTUxFbGVtZW50KSB7XHJcbiAgICB0cnkge1xyXG4gICAgICBjb25zdCBpbWFnZURhdGEgPSBhd2FpdCB0aGlzLmdldEltYWdlKHNtaWxlcyk7XHJcbiAgICAgIGNvbnN0IGltZ0VsID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnaW1nJyk7XHJcbiAgICAgIGNvbnN0IG1pbWVUeXBlID0gdGhpcy5zZXR0aW5ncy5mb3JtYXQucmVwbGFjZSgnO2Jhc2U2NCcsICcreG1sJyk7XHJcbiAgICAgIGltZ0VsLnNyYyA9IGBkYXRhOiR7bWltZVR5cGV9O2Jhc2U2NCwke2ltYWdlRGF0YX1gO1xyXG4gICAgICBpbWdFbC5zdHlsZS53aWR0aCA9IHRoaXMuc2V0dGluZ3Mud2lkdGggKyAncHgnOyBcclxuICAgICAgaW1nRWwuY2xhc3NMaXN0LmFkZCgnY2hlbWljYWwtc3RydWN0dXJlLWltYWdlJyk7XHJcbiAgICAgIC8vIGNvbnNvbGUubG9nKGltZ0VsLnNyYyk7XHJcbiAgICAgIGVsLmFwcGVuZENoaWxkKGltZ0VsKTtcclxuICAgIH0gY2F0Y2ggKGVycm9yKSB7XHJcbiAgICAgIGNvbnNvbGUuZXJyb3IoYEZhaWxlZCB0byByZW5kZXIgU01JTEVTOiAke2Vycm9yfWApO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgYXN5bmMgcmVuZGVySW1hZ2VzRnJvbUNvZGVCbG9jayh0ZXh0OiBzdHJpbmcsIGVsOiBIVE1MRWxlbWVudCkge1xyXG4gICAgY29uc3Qgc21pbGVzTGlzdCA9IHRleHQuc3BsaXQoJ1xcbicpO1xyXG4gICAgY29uc3QgY29udGFpbmVyRWwgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcclxuICAgIGNvbnRhaW5lckVsLmNsYXNzTGlzdC5hZGQoJ2NoZW1pY2FsLXN0cnVjdHVyZS1jb250YWluZXInKTtcclxuICAgIFxyXG4gICAgZm9yIChjb25zdCBzbWlsZXMgb2Ygc21pbGVzTGlzdCkge1xyXG4gICAgICAgIGlmIChzbWlsZXMudHJpbSgpICE9PSAnJykge1xyXG4gICAgICAgICAgICBhd2FpdCB0aGlzLnJlbmRlckltYWdlKHNtaWxlcywgY29udGFpbmVyRWwpO1xyXG4gICAgICAgIH1cclxuICAgIH1cclxuICAgIGVsLmFwcGVuZENoaWxkKGNvbnRhaW5lckVsKTtcclxuICB9XHJcblxyXG4gIGFzeW5jIG9ubG9hZCgpIHtcclxuICAgIGNvbnNvbGUubG9nKFwibG9hZGluZyBDaGVtaWNhbCBTdHJ1Y3R1cmUgUmVuZGVyZXIgUGx1Z2luXCIpO1xyXG4gICAgYXdhaXQgdGhpcy5sb2FkU2V0dGluZ3MoKTtcclxuXHJcbiAgICB0aGlzLmFkZFNldHRpbmdUYWIobmV3IENoZW1pY2FsU3RydWN0dXJlUmVuZGVyZXJTZXR0aW5nc1RhYiAodGhpcy5hcHAsIHRoaXMpKTtcclxuXHJcbiAgICB0aGlzLnJlZ2lzdGVyTWFya2Rvd25Db2RlQmxvY2tQcm9jZXNzb3IoJ3NtaWxlcycsIGFzeW5jIChzb3VyY2UsIGVsLCBjdHgpID0+IHtcclxuICAgICAgY29uc3Qgc21pbGVzID0gc291cmNlLnRyaW0oKTtcclxuICAgICAgYXdhaXQgdGhpcy5yZW5kZXJJbWFnZXNGcm9tQ29kZUJsb2NrKHNtaWxlcywgZWwpO1xyXG4gICAgfSk7XHJcblxyXG4gICAgdGhpcy5yZWdpc3Rlck1hcmtkb3duUG9zdFByb2Nlc3Nvcihhc3luYyAoZWwsIGN0eCkgPT4ge1xyXG4gICAgICBlbC5xdWVyeVNlbGVjdG9yQWxsKCdjb2RlLmxhbmd1YWdlLXNtaWxlcycpLmZvckVhY2goYXN5bmMgKGNvZGVFbGVtZW50KSA9PiB7XHJcbiAgICAgICAgY29uc3Qgc21pbGVzID0gY29kZUVsZW1lbnQudGV4dENvbnRlbnQgfHwgJyc7XHJcbiAgICAgICAgYXdhaXQgdGhpcy5yZW5kZXJJbWFnZXNGcm9tQ29kZUJsb2NrKHNtaWxlcywgZWwpO1xyXG4gICAgICB9KTtcclxuICAgIH0pO1xyXG5cclxuICB9XHJcblxyXG4gIG9udW5sb2FkKCk6IHZvaWQge1xyXG4gICAgY29uc29sZS5sb2coXCJ1bmxvYWRpbmcgQ2hlbWljYWwgU3RydWN0dXJlIFJlbmRlcmVyIFBsdWdpblwiKTtcclxuICB9XHJcblxyXG4gIGFzeW5jIGxvYWRTZXR0aW5ncygpOiBQcm9taXNlPHZvaWQ+IHtcclxuICAgIHRoaXMuc2V0dGluZ3MgPSBPYmplY3QuYXNzaWduKHt9LCBERUZBVUxUX1NFVFRJTkdTLCBhd2FpdCB0aGlzLmxvYWREYXRhKCkpO1xyXG4gIH1cclxuXHJcbiAgYXN5bmMgc2F2ZVNldHRpbmdzKCk6IFByb21pc2U8dm9pZD4ge1xyXG4gICAgYXdhaXQgdGhpcy5zYXZlRGF0YSh0aGlzLnNldHRpbmdzKTtcclxuICB9XHJcbn1cclxuXHJcblxyXG5cclxuIiwgImltcG9ydCB7IEFwcCwgUGx1Z2luU2V0dGluZ1RhYiwgU2V0dGluZyB9IGZyb20gJ29ic2lkaWFuJztcclxuaW1wb3J0IENoZW1pY2FsU3RydWN0dXJlUmVuZGVyZXJQbHVnaW4gIGZyb20gJy4vbWFpbic7XHJcblxyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDaGVtaWNhbFN0cnVjdHVyZVJlbmRlcmVyU2V0dGluZ3NUYWIgIGV4dGVuZHMgUGx1Z2luU2V0dGluZ1RhYiB7XHJcbiAgcGx1Z2luOiBDaGVtaWNhbFN0cnVjdHVyZVJlbmRlcmVyUGx1Z2luIDtcclxuXHJcbiAgY29uc3RydWN0b3IoYXBwOiBBcHAsIHBsdWdpbjogQ2hlbWljYWxTdHJ1Y3R1cmVSZW5kZXJlclBsdWdpbiApIHtcclxuICAgIHN1cGVyKGFwcCwgcGx1Z2luKTtcclxuICAgIHRoaXMucGx1Z2luID0gcGx1Z2luO1xyXG4gIH1cclxuXHJcbiAgZGlzcGxheSgpOiB2b2lkIHtcclxuICAgIGxldCB7IGNvbnRhaW5lckVsIH0gPSB0aGlzO1xyXG5cclxuICAgIGNvbnRhaW5lckVsLmVtcHR5KCk7XHJcblxyXG4gICAgY29udGFpbmVyRWwuY3JlYXRlRWwoJ2gyJywgeyB0ZXh0OiAnQ2hlbWljYWwgU3RydWN0dXJlIFJlbmRlcmVyIFBsdWdpbiBTZXR0aW5ncycgfSk7XHJcblxyXG4gICAgbmV3IFNldHRpbmcoY29udGFpbmVyRWwpXHJcbiAgICAgIC5zZXROYW1lKCdXaWR0aCcpXHJcbiAgICAgIC5zZXREZXNjKCdTZXQgdGhlIHdpZHRoIG9mIHRoZSByZW5kZXJlZCBzdHJ1Y3R1cmUgKG11c3QgYmUgYSBudW1iZXIhKScpXHJcbiAgICAgIC5hZGRUZXh0KHRleHQgPT4gdGV4dFxyXG4gICAgICAgIC5zZXRQbGFjZWhvbGRlcignRW50ZXIgd2lkdGgnKVxyXG4gICAgICAgIC5zZXRWYWx1ZSh0aGlzLnBsdWdpbi5zZXR0aW5ncy53aWR0aClcclxuICAgICAgICAub25DaGFuZ2UoYXN5bmMgKHZhbHVlKSA9PiB7XHJcbiAgICAgICAgICB0aGlzLnBsdWdpbi5zZXR0aW5ncy53aWR0aCA9IHZhbHVlO1xyXG4gICAgICAgICAgYXdhaXQgdGhpcy5wbHVnaW4uc2F2ZVNldHRpbmdzKCk7XHJcbiAgICAgICAgfSkpO1xyXG5cclxuICAgIG5ldyBTZXR0aW5nKGNvbnRhaW5lckVsKVxyXG4gICAgICAuc2V0TmFtZSgnU2VydmVyJylcclxuICAgICAgLnNldERlc2MoJ1NldCB0aGUgc2VydmVyIHRvIHVzZSBmb3IgcmVuZGVyaW5nJylcclxuICAgICAgLmFkZFRleHQodGV4dCA9PiB0ZXh0XHJcbiAgICAgICAgLnNldFBsYWNlaG9sZGVyKCdFbnRlciBzZXJ2ZXIgVVJMJylcclxuICAgICAgICAuc2V0VmFsdWUodGhpcy5wbHVnaW4uc2V0dGluZ3Muc2VydmVyKVxyXG4gICAgICAgIC5vbkNoYW5nZShhc3luYyAodmFsdWUpID0+IHtcclxuICAgICAgICAgIHRoaXMucGx1Z2luLnNldHRpbmdzLnNlcnZlciA9IHZhbHVlO1xyXG4gICAgICAgICAgYXdhaXQgdGhpcy5wbHVnaW4uc2F2ZVNldHRpbmdzKCk7XHJcbiAgICAgICAgfSkpO1xyXG5cclxuICAgIG5ldyBTZXR0aW5nKGNvbnRhaW5lckVsKVxyXG4gICAgLnNldE5hbWUoJ0ltYWdlIGZvcm1hdCcpXHJcbiAgICAuc2V0RGVzYygnQ2hvb3NlIHRoZSBmb3JtYXQgb2YgdGhlIHJlbmRlcmVkIGltYWdlJylcclxuICAgIC5hZGREcm9wZG93bihkcm9wZG93biA9PiB7XHJcbiAgICAgIGRyb3Bkb3duXHJcbiAgICAgICAgLmFkZE9wdGlvbignaW1hZ2Uvc3ZnO2Jhc2U2NCcsICdTVkcnKVxyXG4gICAgICAgIC5hZGRPcHRpb24oJ2ltYWdlL3BuZztiYXNlNjQnLCAnUE5HJylcclxuICAgICAgICAuc2V0VmFsdWUodGhpcy5wbHVnaW4uc2V0dGluZ3MuZm9ybWF0KVxyXG4gICAgICAgIC5vbkNoYW5nZShhc3luYyAodmFsdWU6ICdpbWFnZS9zdmc7YmFzZTY0JyB8ICdpbWFnZS9wbmc7YmFzZTY0JykgPT4ge1xyXG4gICAgICAgICAgdGhpcy5wbHVnaW4uc2V0dGluZ3MuZm9ybWF0ID0gdmFsdWU7XHJcbiAgICAgICAgICBhd2FpdCB0aGlzLnBsdWdpbi5zYXZlU2V0dGluZ3MoKTtcclxuICAgICAgICB9KTtcclxuICAgIH0pO1xyXG4gIH1cclxufVxyXG4iXSwKICAibWFwcGluZ3MiOiAiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUEsSUFBQUEsbUJBQW1DOzs7QUNBbkMsc0JBQStDO0FBRy9DLElBQXFCLHVDQUFyQixjQUFtRSxpQ0FBaUI7QUFBQSxFQUdsRixZQUFZLEtBQVUsUUFBMEM7QUFDOUQsVUFBTSxLQUFLLE1BQU07QUFDakIsU0FBSyxTQUFTO0FBQUEsRUFDaEI7QUFBQSxFQUVBLFVBQWdCO0FBQ2QsUUFBSSxFQUFFLFlBQVksSUFBSTtBQUV0QixnQkFBWSxNQUFNO0FBRWxCLGdCQUFZLFNBQVMsTUFBTSxFQUFFLE1BQU0sOENBQThDLENBQUM7QUFFbEYsUUFBSSx3QkFBUSxXQUFXLEVBQ3BCLFFBQVEsT0FBTyxFQUNmLFFBQVEsNkRBQTZELEVBQ3JFLFFBQVEsVUFBUSxLQUNkLGVBQWUsYUFBYSxFQUM1QixTQUFTLEtBQUssT0FBTyxTQUFTLEtBQUssRUFDbkMsU0FBUyxPQUFPLFVBQVU7QUFDekIsV0FBSyxPQUFPLFNBQVMsUUFBUTtBQUM3QixZQUFNLEtBQUssT0FBTyxhQUFhO0FBQUEsSUFDakMsQ0FBQyxDQUFDO0FBRU4sUUFBSSx3QkFBUSxXQUFXLEVBQ3BCLFFBQVEsUUFBUSxFQUNoQixRQUFRLHFDQUFxQyxFQUM3QyxRQUFRLFVBQVEsS0FDZCxlQUFlLGtCQUFrQixFQUNqQyxTQUFTLEtBQUssT0FBTyxTQUFTLE1BQU0sRUFDcEMsU0FBUyxPQUFPLFVBQVU7QUFDekIsV0FBSyxPQUFPLFNBQVMsU0FBUztBQUM5QixZQUFNLEtBQUssT0FBTyxhQUFhO0FBQUEsSUFDakMsQ0FBQyxDQUFDO0FBRU4sUUFBSSx3QkFBUSxXQUFXLEVBQ3RCLFFBQVEsY0FBYyxFQUN0QixRQUFRLHlDQUF5QyxFQUNqRCxZQUFZLGNBQVk7QUFDdkIsZUFDRyxVQUFVLG9CQUFvQixLQUFLLEVBQ25DLFVBQVUsb0JBQW9CLEtBQUssRUFDbkMsU0FBUyxLQUFLLE9BQU8sU0FBUyxNQUFNLEVBQ3BDLFNBQVMsT0FBTyxVQUFtRDtBQUNsRSxhQUFLLE9BQU8sU0FBUyxTQUFTO0FBQzlCLGNBQU0sS0FBSyxPQUFPLGFBQWE7QUFBQSxNQUNqQyxDQUFDO0FBQUEsSUFDTCxDQUFDO0FBQUEsRUFDSDtBQUNGOzs7QUQ1Q0EsSUFBTSxtQkFBdUQ7QUFBQSxFQUMzRCxPQUFPO0FBQUEsRUFDUCxRQUFRO0FBQUEsRUFDUixRQUFRO0FBQ1Y7QUFFQSxJQUFxQixrQ0FBckIsY0FBOEQsd0JBQU87QUFBQSxFQUduRSxNQUFNLFNBQVMsUUFBaUM7QUFDOUMsVUFBTSxXQUFXLFVBQU0sNkJBQVc7QUFBQSxNQUNoQyxLQUFLLEtBQUssU0FBUyxTQUFTO0FBQUEsTUFDNUIsUUFBUTtBQUFBLE1BQ1IsU0FBUztBQUFBLFFBQ1AsZ0JBQWdCO0FBQUEsUUFDaEIsVUFBVSxLQUFLLFNBQVM7QUFBQSxNQUMxQjtBQUFBLE1BQ0EsTUFBTSxLQUFLLFVBQVU7QUFBQSxRQUNuQixRQUFRO0FBQUEsUUFDUixPQUFPO0FBQUEsUUFDUCxlQUFlLEtBQUssU0FBUztBQUFBLFFBQzdCLFNBQVMsQ0FBQztBQUFBLE1BQ1osQ0FBQztBQUFBLElBQ0gsQ0FBQztBQUVELFdBQU8sU0FBUztBQUFBLEVBQ2xCO0FBQUEsRUFFQSxNQUFNLFlBQVksUUFBZ0IsSUFBaUI7QUFDakQsUUFBSTtBQUNGLFlBQU0sWUFBWSxNQUFNLEtBQUssU0FBUyxNQUFNO0FBQzVDLFlBQU0sUUFBUSxTQUFTLGNBQWMsS0FBSztBQUMxQyxZQUFNLFdBQVcsS0FBSyxTQUFTLE9BQU8sUUFBUSxXQUFXLE1BQU07QUFDL0QsWUFBTSxNQUFNLFFBQVEsbUJBQW1CO0FBQ3ZDLFlBQU0sTUFBTSxRQUFRLEtBQUssU0FBUyxRQUFRO0FBQzFDLFlBQU0sVUFBVSxJQUFJLDBCQUEwQjtBQUU5QyxTQUFHLFlBQVksS0FBSztBQUFBLElBQ3RCLFNBQVMsT0FBUDtBQUNBLGNBQVEsTUFBTSw0QkFBNEIsT0FBTztBQUFBLElBQ25EO0FBQUEsRUFDRjtBQUFBLEVBRUEsTUFBTSwwQkFBMEIsTUFBYyxJQUFpQjtBQUM3RCxVQUFNLGFBQWEsS0FBSyxNQUFNLElBQUk7QUFDbEMsVUFBTSxjQUFjLFNBQVMsY0FBYyxLQUFLO0FBQ2hELGdCQUFZLFVBQVUsSUFBSSw4QkFBOEI7QUFFeEQsZUFBVyxVQUFVLFlBQVk7QUFDN0IsVUFBSSxPQUFPLEtBQUssTUFBTSxJQUFJO0FBQ3RCLGNBQU0sS0FBSyxZQUFZLFFBQVEsV0FBVztBQUFBLE1BQzlDO0FBQUEsSUFDSjtBQUNBLE9BQUcsWUFBWSxXQUFXO0FBQUEsRUFDNUI7QUFBQSxFQUVBLE1BQU0sU0FBUztBQUNiLFlBQVEsSUFBSSw0Q0FBNEM7QUFDeEQsVUFBTSxLQUFLLGFBQWE7QUFFeEIsU0FBSyxjQUFjLElBQUkscUNBQXNDLEtBQUssS0FBSyxJQUFJLENBQUM7QUFFNUUsU0FBSyxtQ0FBbUMsVUFBVSxPQUFPLFFBQVEsSUFBSSxRQUFRO0FBQzNFLFlBQU0sU0FBUyxPQUFPLEtBQUs7QUFDM0IsWUFBTSxLQUFLLDBCQUEwQixRQUFRLEVBQUU7QUFBQSxJQUNqRCxDQUFDO0FBRUQsU0FBSyw4QkFBOEIsT0FBTyxJQUFJLFFBQVE7QUFDcEQsU0FBRyxpQkFBaUIsc0JBQXNCLEVBQUUsUUFBUSxPQUFPLGdCQUFnQjtBQUN6RSxjQUFNLFNBQVMsWUFBWSxlQUFlO0FBQzFDLGNBQU0sS0FBSywwQkFBMEIsUUFBUSxFQUFFO0FBQUEsTUFDakQsQ0FBQztBQUFBLElBQ0gsQ0FBQztBQUFBLEVBRUg7QUFBQSxFQUVBLFdBQWlCO0FBQ2YsWUFBUSxJQUFJLDhDQUE4QztBQUFBLEVBQzVEO0FBQUEsRUFFQSxNQUFNLGVBQThCO0FBQ2xDLFNBQUssV0FBVyxPQUFPLE9BQU8sQ0FBQyxHQUFHLGtCQUFrQixNQUFNLEtBQUssU0FBUyxDQUFDO0FBQUEsRUFDM0U7QUFBQSxFQUVBLE1BQU0sZUFBOEI7QUFDbEMsVUFBTSxLQUFLLFNBQVMsS0FBSyxRQUFRO0FBQUEsRUFDbkM7QUFDRjsiLAogICJuYW1lcyI6IFsiaW1wb3J0X29ic2lkaWFuIl0KfQo=
