// ==UserScript==
// @name         Bromcom VLE Tools
// @namespace    http://radialbog9.uk/
// @version      2024-04-23_03
// @description  Bromcom VLE dashboard widget
// @author       Radialbog9
// @match        https://vle.bromcomcloud.com/*
// @downloadURL https://git.rb9.xyz/TheJoeCoder/bromcom-vle-to-ics/-/raw/main/bvletools.user.js
// @updateURL https://git.rb9.xyz/TheJoeCoder/bromcom-vle-to-ics/-/raw/main/bvletools.user.js
// @icon         data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==
// @grant        none
// ==/UserScript==

/*

<div class="grid-stack-item ui-draggable ui-resizable ui-resizable-autohide ui-resizable-disabled" id="gs_RB9Buttons" data-color="danger" data-gs-id="gs_RB9Buttons" data-gs-x="8" data-gs-y="2" data-gs-width="4" data-gs-height="2" data-gs-no-resize="yes">
        <div class="panel panel-danger shadow grid-stack-item-content ui-draggable-handle">
            <div class="panel-heading">
                <table>
                    <tbody>
                        <tr class="tableheader">
                            <td><i style="font-size:35px; padding-right:5px; padding-left:5px" class="fa fa fa-wrench "></i></td>
                            <td>
                                <h3 class="panel-title">Toolkit</h3><h5 class="panelSubTitle">Utilities Toolkit</h5>
                            </td>
                        </tr>
                        <tr></tr>
                    </tbody>
                </table>
            </div>
            <div id="content_RB9Buttons" style="display:block; width: 100%;padding:0px;" class="ifNoDataInWidget">
                <span class="txtalignCenter"><a id="rb9ButtonGetTTWeek">Get Timetable (This Week)</a></span>
            </div>
        </div><div class="ui-resizable-handle ui-resizable-se ui-icon ui-icon-gripsmall-diagonal-se" style="z-index: 90; display: none;"></div>
    </div>
*/

(function() {
    'use strict';
    function formatDate(date) {
        var d = new Date(date),
            month = '' + (d.getMonth() + 1),
            day = '' + d.getDate(),
            year = d.getFullYear();

        if (month.length < 2) {month = '0' + month;}
        if (day.length < 2) {day = '0' + day;}

        return [year, month, day].join('-');
    }

    function generateUtilButtonText(id, text) {
        var elem = "<span class=\"txtalignCenter\">";
        elem += `<a id="${id}">${text}</a>`;
        elem += "</span>";
        elem += "<br />";
        return elem;
    }

    function appendUtilButton(id, text) {
        $("#content_RB9Buttons").append(generateUtilButtonText(id, text));
    }

    function timetableToClipboardProcess(data) {
        var data_str = JSON.stringify(data);
        console.log("[RB9] " + data_str);
        navigator.clipboard.writeText(data_str);
        alert("Copied to Clipboard.\n Number of lessons " + data["table"].length);
    }

    if (window.location.href.endsWith("/Home/Dashboard")) {
        console.log("[RB9] Page is Dashboard, injecting widget!");

        $("#widgetsDahsboard .grid-stack")
            .append("\n<div class=\"grid-stack-item ui-draggable ui-resizable ui-resizable-autohide ui-resizable-disabled\" id=\"gs_RB9Buttons\" data-color=\"danger\" data-gs-id=\"gs_RB9Buttons\" data-gs-x=\"8\" data-gs-y=\"2\" data-gs-width=\"4\" data-gs-height=\"2\" data-gs-no-resize=\"yes\">\n        <div class=\"panel panel-danger shadow grid-stack-item-content ui-draggable-handle\">\n            <div class=\"panel-heading\">\n                <table>\n                    <tbody>\n                        <tr class=\"tableheader\">\n                            <td><i style=\"font-size:35px; padding-right:5px; padding-left:5px\" class=\"fa fa fa-wrench \"><\/i><\/td>\n                            <td>\n                                <h3 class=\"panel-title\">Toolkit<\/h3><h5 class=\"panelSubTitle\">Utilities Toolkit<\/h5>\n                            <\/td>\n                        <\/tr>\n                        <tr><\/tr>\n                    <\/tbody>\n                <\/table>\n            <\/div>\n            <div id=\"content_RB9Buttons\" style=\"display:block; width: 100%;padding:0px;\" class=\"ifNoDataInWidget\">\n<\/div>\n        <\/div><div class=\"ui-resizable-handle ui-resizable-se ui-icon ui-icon-gripsmall-diagonal-se\" style=\"z-index: 90; display: none;\"><\/div>\n    <\/div>");

        //$("#content_RB9Buttons").append("<span class=\"txtalignCenter\"><a id=\"rb9ButtonGetTTWeek\">Get Timetable (This Week)<\/a><\/span>");
        //$("#content_RB9Buttons").append("<br /><a onclick=\"alert(userGuidingUserId.split('$')[0]);\">Get User ID</a>");

        appendUtilButton("rb9ButtonGetTTWeek", "Get Timetable (This Week)");
        appendUtilButton("rb9ButtonGetTTWeekNext", "Get Timetable (Next Week)");
        appendUtilButton("rb9ButtonGetUserId", "Get User ID");

        $("#rb9ButtonGetUserId").on("click", () => {
            var userIdParts = userGuidingUserId.split("$");
            var id_user = userIdParts[0];
            var id_institution = userIdParts[1];
            alert(`User ID: ${id_user}\nInstitution ID: ${id_institution}`);
        });

        $("#rb9ButtonGetTTWeek").on("click", () => {
            var now = new Date();
            var today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
            var lastSunday = new Date(today.setDate(today.getDate()-today.getDay()));
            var nextSaturday = new Date(lastSunday).setDate(lastSunday.getDate() + 6);
            var url = "https://vle.bromcomcloud.com/Timetable/GetTimeTable?WeekStartDate=" + formatDate(lastSunday) + "&weekEndDate=" + formatDate(nextSaturday) + "&type=1&id=0";
            $.ajax({url: url, method: "POST", dataType: "json"})
                .done((data) => {
                timetableToClipboardProcess(data);
            });
        });

        $("#rb9ButtonGetTTWeekNext").on("click", () => {
            var now = new Date();
            var today = new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7); // Forward 1 week
            var lastSunday = new Date(today.setDate(today.getDate()-today.getDay()));
            var nextSaturday = new Date(lastSunday).setDate(lastSunday.getDate() + 6);
            var url = "https://vle.bromcomcloud.com/Timetable/GetTimeTable?WeekStartDate=" + formatDate(lastSunday) + "&weekEndDate=" + formatDate(nextSaturday) + "&type=1&id=0";
            $.ajax({url: url, method: "POST", dataType: "json"})
                .done((data) => {
                timetableToClipboardProcess(data);
            });
        });
    }
    // Behaviour page script modifications
    if (window.location.href.endsWith("/Behaviour")) {
        console.log("[RB9] Behaviour function handlers");
        // copied from https://vle.bromcomcloud.com/lib/pages/js/behaviour.js
        var toCamelCase = (str) => {
            return str.replace(/(?:^\w|[A-Z]|\b\w)/g, function (word, index) {
                return index == 0 ? word.toLowerCase() : word.toUpperCase();
            }).replace(/\s+/g, '');
        }

        // copied from https://vle.bromcomcloud.com/lib/pages/js/behaviour.js
        var loadBehaviourTable = () => {
            $(".wait").show();
            $.ajax({
                url: "/Behaviour/StudentBehaviour",
                type: "Post",
                data: null,
                contentType: false,
                processData: false,
                cache: false,
                success: function (data) {
                    console.log(data);
                    $(".wait").hide();
                    var content = "";

                    var headerContentArr = [].concat(data.behaviourStudentEventHeader);
                    var lastPositionFromTop = 1;

                    if (headerContentArr.length > 0) {
                        lastPositionFromTop = headerContentArr[headerContentArr.length - 1].positionFromTop;
                    }

                    // Collect list of all field names
                    var headerContentArrKeys = [];
                    for(var j = 0; j < headerContentArr.length; j++) {
                        var cc = toCamelCase(data.behaviourStudentEventHeader[j].fieldName = data.behaviourStudentEventHeader[j].fieldName == "" ? data.behaviourStudentEventHeader[j].displayName : data.behaviourStudentEventHeader[j].fieldName);
                        headerContentArrKeys.push(cc);
                    }

                    console.log("[RB9] Existing field names: ");
                    console.log(headerContentArrKeys);


                    // Append any non-existing contents to header
                    var studentEvents = [].concat(data.studentEvents);

                    if (studentEvents.length > 0) {
                        var headerFirstObjectKeys = Object.keys(studentEvents[0]);
                        for(var i = 0; i < headerFirstObjectKeys.length; i++) {
                            var key = headerFirstObjectKeys[i];
                            if(!headerContentArrKeys.includes(key)) {
                                var data = {
                                    active: "True",
                                    fieldName: key,
                                    displayName: key,
                                    positionFromTop: lastPositionFromTop
                                };

                                headerContentArrKeys.push(data);
                                console.log("[RB9] " + JSON.stringify(data));

                                lastPositionFromTop++;
                            }
                        }
                    }

                    var headerContent = "";
                    headerContent += "<tr>"
                    for (var i = 0; i < headerContentArr.length; i++) {
                        headerContent += "<th>" + headerContentArr[i].displayName.replace(/([A-Z])/g, ' $1').trim() + "</th>"
                    }
                    headerContent += "</tr>"

                    if (studentEvents.length > 0) {
                        for (var i = 0; i < studentEvents.length; i++) {
                            content += "<tr>"
                            for (var j = 0; j < headerContentArr.length; j++) {
                                content += '<td>' +
                                    studentEvents[i][toCamelCase(headerContentArr[j].fieldName = headerContentArr[j].fieldName == "" ? headerContentArr[j].displayName : headerContentArr[j].fieldName)] + '</td>';
                            }
                            content += "</tr>"
                        }
                    }

                    $('#Behaviour thead').empty();
                    $('#Behaviour tbody').empty();
                    $('#Behaviour thead').html(headerContent);
                    $('#Behaviour tbody').html(content);


                    $.fn.dataTable.moment('DD/MM/YYYY HH:mm');

                    $('#Behaviour').DataTable({
                        "bPaginate": false,
                        columnDefs: [{
                            target: [0],
                            type: 'datetime-moment'
                        }],
                        "order": [[0,'desc']],
                        "fnDrawCallback": function () {
                            $('th').each(function () {
                                if (($(this).hasClass('sorting')) || ($(this).hasClass('sorting_desc'))) {
                                    $(this).attr({ title: 'Sort Ascending' });
                                } else {
                                    $(this).attr({ title: 'Sort Descending' });
                                }
                            });
                        }
                    });
                },
                error: function (msg) {
                    $(".wait").hide();
                }
            });
        }

        $(".calendar-toolbar").append("<div class=\"form-group\">" +
            "<a id=\"rb9ButtonBehavRefresh\">Refresh Behaviour Table</a>" +
            "</div>");
        
        $("#rb9ButtonBehavRefresh").on("click", () => {
            console.log("[RB9] Destroying existing table.");
            if($.fn.DataTable.isDataTable("#Behaviour")) {
                $("#Behaviour").DataTable().destroy();
            }
            $("#Behaviour").empty();
            console.log("[RB9] Creating new table.");
            // <table id="Behaviour" class="DataTable table table-theme dataTable"><thead></thead><tbody></tbody></table>
            /*$("#BehaviourDiv").append(
                "<table id=\"Behaviour\" class=\"DataTable table table-theme\">" +
                "<thead></thead>" +
                "<tbody></tbody>" +
                "</table>");*/
            $("#Behaviour").append("<thead></thead>");
            $("#Behaviour").append("<tbody></tbody>");
            loadBehaviourTable();
        });
    }
})();
