from absled import ILedString


class DummyLedString(ILedString):
    def __init__(self, location, length: int):
        super().__init__(location, length)
        self.location = location
        self.leds = [(0, 0, 0)] * length
        self.real_leds = [(0, 0, 0)] * length

    def set_led(self, color: tuple[int, int, int], index: int):
        self.leds[index] = color

    def fill_leds(self, color: tuple[int, int, int]):
        self.leds = [color] * len(self.leds)

    def set_leds_color(self, color: tuple[int, int, int], start_index, end_index, step=1):
        for i in range(start_index, end_index + 1, step):
            self.leds[i] = color

    def set_leds_colors(self, colors: list[tuple[int, int, int]], start_index=0):
        for i, color in enumerate(colors):
            if i + start_index >= len(self.leds):
                break
            self.leds[i + start_index] = color

    def show(self):
        self.real_leds = self.leds.copy()
        print("LED State:", self.leds)