from absled import ILedString
# noinspection PyUnresolvedReferences,PyPackageRequirements
import board
# noinspection PyUnresolvedReferences, PyPackageRequirements
import neopixel

class NeopixelLedString(ILedString):
    def __init__(self, location, length: int):
        super().__init__(location, length)
        self.location = getattr(board, location)
        self.leds = neopixel.NeoPixel(self.location, length, brightness=0.3, auto_write=False)

    def set_led(self, color: tuple[int, int, int], index: int):
        self.leds[index] = color

    def fill_leds(self, color: tuple[int, int, int]):
        self.leds.fill(color)

    def set_leds_color(self, color: tuple[int, int, int], start_index, end_index, step=1):
        for i in range(start_index, end_index + 1, step):
            self.leds[i] = color

    def set_leds_colors(self, colors: list[tuple[int, int, int]], start_index=0):
        for i, color in enumerate(colors):
            if i + start_index >= len(self.leds):
                break
            self.leds[i + start_index] = color

    def show(self):
        self.leds.show()
