# cs-fancy-clock

A simple clock that displays the current time in a fancy way.


## Installation (on Pi Zero W)

Use Wayland for the display server, especially if you're using an SPI display. X11 may also be too slow.

To install:
```bash
# Install the necessary dependencies
sudo apt install python3 python3-dev python3-pip python3-pygame -y
sudo apt install wayfire xwayland -y

# Clone the repository and install the dependencies
cd ~
git clone https://git.rb9.xyz/TheJoeCoder/cs-fancy-clock
cd cs-fancy-clock
python3 -m venv .venv

# Install the requirements
# Omit the -r requirements.neopixel.txt if you don't have a neopixel strip
./.venv/bin/pip install -r requirements.txt -r requirements.neopixel.txt
```


Then to run, run the pre-made script:
```bash
./run-pi.sh
```

Or, alternatively, you can run the commands manually.
```bash
# Change access permissions for Wayland (insecure but necessary)
xhost +
# Run the clock
sudo ./.venv/bin/python3 main.py
```

## Architecture
The main system running the software is a Raspberry Pi Zero 2 W. The display is a 240x240 pixel SPI display.

In terms of software stack:
- The clock's software is written in Python, using the Pygame library for rendering the display.
- The software is multithreaded:
  - One thread for the display, which renders the display (with pygame).
  - One thread for the LEDs, controlling the patterns (with either neopixel or dummy led libraries).
  - One thread for the web server, which serves the configuration page and API endpoints.
  - The main thread controls the other threads and handles changes to the configuration.
- Wayland is used as the display server, as it is faster than X11 and works well with the SPI display.
- For operating system we use Raspberry Pi OS Lite, with Wayland and the necessary dependencies installed.

It's designed to be:
- Modular, with different modules - both widgets for the display and patterns for the LEDs that 
  can be added or removed. The clock can be configured to display different modules in different orders, 
  and the modules can be easily created or modified.
- Easily extensible, with a simple API for creating new modules. The clock is also designed to be 
  easily configurable, with a simple configuration file that can be edited to change the appearance of the clock.
