from config import PROP_SCREEN_WIDTH, PROP_SCREEN_HEIGHT, PROP_WINDOW_SCALE


def get_screen_centre():
    return (PROP_SCREEN_WIDTH * PROP_WINDOW_SCALE) / 2, (PROP_SCREEN_HEIGHT * PROP_WINDOW_SCALE) / 2


# noinspection PyTypeChecker
def color_hex_to_tuple(hx: str) -> tuple[int, int, int]:
    """
    Convert a 6-digit hex colour string to a tuple of RGB values.
    If a hash symbol is present, it is removed.
    :param hx: the hex colour string
    :return: the RGB tuple
    """
    hx = hx.removeprefix("#")
    return tuple(int(hx[i:i + 2], 16) for i in (0, 2, 4))
