import os.path
import json

default_hw_config = {
    "screen_width": 240,
    "screen_height": 280,
    "window_fullscreen": True,
    "hide_mouse": True,
    "window_scale": 2,
    "leds_driver": "npixel",
    "leds_location": "D12",
    "leds_length": 15,
    "flask_debug": False,
    "flask_host": "0.0.0.0",
    "flask_port": 5000,
    "show_fps": False,
    "fps_max": 60,
    "main_update_frequency": 500
}

hw_config = default_hw_config.copy()
if os.path.exists("hw_config.json"):
    with open("hw_config.json", "r") as f:
        hw_config.update(json.load(f))

with open("hw_config.json", "w") as f:
    json.dump(hw_config, f, indent=4)

PROP_SCREEN_WIDTH = hw_config["screen_width"]
PROP_SCREEN_HEIGHT = hw_config["screen_height"]

PROP_WINDOW_FULLSCREEN = hw_config["window_fullscreen"]

PROP_HIDE_MOUSE = hw_config["hide_mouse"]

# Make the window scale larger for development
PROP_WINDOW_SCALE = hw_config["window_scale"]

PROP_FLASK_DEBUG = hw_config["flask_debug"]
PROP_FLASK_HOST = hw_config["flask_host"]
PROP_FLASK_PORT = hw_config["flask_port"]

PROP_LEDS_DRIVER = hw_config["leds_driver"]
PROP_LEDS_LOCATION = hw_config["leds_location"]
PROP_LEDS_LENGTH = hw_config["leds_length"]


PROP_AVAILABLE_WIDGETS = [
    "IPShowWidget",
    "TestWidget",
    "AnalogClockWidget",
    "DigitalClockWidget"
]

PROP_AVAILABLE_PATTERNS = [
    "RainbowPattern",
    "SolidColorPattern"
]
