import os
import re


def get_font_path_or_default(pygame, font_name: str|None, bold=False, italic=False) -> str:
    if font_name is not None:
        if re.match(r".+\.ttf", font_name):
            if os.path.exists(font_name):
                font_path = font_name
            else:
                font_path = pygame.font.get_default_font()
        else:
            font_path = pygame.font.match_font(font_name, bold, italic)
    else:
        font_path = pygame.font.get_default_font()
    return font_path
