import base64
import json

from utils.net import json_response


def encode_dict(d: dict|list) -> str:
    return base64.b64encode(json.dumps(d).encode("utf-8")).decode("utf-8")

def decode_dict(s: str) -> dict|list:
    return json.loads(base64.b64decode(s.encode("utf-8")).decode("utf-8"))

def get_cfg_from_request(request):
    config_override = request.json.get("config", {})
    if type(config_override) is not dict:
        return None, json_response({
            "error": "Config must be an Object"
        }, 400)

    config_b64 = encode_dict(config_override)
    return config_b64, None