def validate_sequence(seq: dict, available_seq_type: list[str]) -> bool:
    """
    Validates the entry sequence

    All of these conditions must be met:
    - seq is a dictionary
    - seq has a "type" key
    - seq["type"] is in available_seq_type
    - seq has a "duration" key
    - seq["duration"] is an integer or float
    - seq["config_override"] is a dictionary or is not set
    :param seq: the entry sequence
    :param available_seq_type: the available sequence types
    :return: True or False
    """
    return all([
        isinstance(seq, dict),
        "type" in seq,
        seq.get("type") in available_seq_type,
        "duration" in seq,
        isinstance(seq.get("duration"), (int, float)),
        isinstance(seq.get("config_override", {}), dict)
    ])