import os.path

import requests

# weather['name']
# weather['weather'][0]['description']
# weather['weather'][0]['icon']
# weather['main']['temp']
# weather['main']['feels_like']

class Weather:
    def __init__(self, api_key, latitude, longitude, weather_units):
        self.api_key = api_key
        self.lat = latitude
        self.long = longitude
        self.weather_units = weather_units
    def get_weather(self):
        r = requests.get(f"https://api.openweathermap.org/data/2.5/weather?lat={self.lat}&lon={self.long}&appid={self.api_key}&units={self.weather_units}")

        if r.status_code != 200:
            return None
        jsn = r.json()

        if "weather" not in jsn or len(jsn.get("weather", [])) == 0:
            return None

        # Get icon path
        icon = jsn['weather'][0]['icon']
        icon_path = f"icons/weather/{icon}@2x.png"

        if not os.path.exists(icon_path):
            icon_path = ""

        return {
            "name": jsn['name'],
            "description": jsn['weather'][0]['description'],
            "icon": icon_path,
            "temp": jsn['main']['temp'],
            "feels_like": jsn['main']['feels_like']
        }
