import psutil
import humanize
from flask import Flask

app = Flask(__name__)


@app.route("/cpu/usage")
def cpu_usage():
    return {"usage": psutil.cpu_percent()}


@app.route("/cpu/freq")
def cpu_frequency():
    cpuf = psutil.cpu_freq()
    return {
        "current": cpuf.current,
        "max": cpuf.max,
        "min": cpuf.min
    } 


@app.route("/ram/physical")
def pmem_usage():
    ram = psutil.virtual_memory()
    return {
        "percent": ram.percent,
        "total": ram.total,
        "free": ram.free,
        "used": ram.used,
        "available": ram.available,
        "total_fancy": humanize.naturalsize(ram.total, binary=True),
        "free_fancy": humanize.naturalsize(ram.free, binary=True),
        "used_fancy": humanize.naturalsize(ram.used, binary=True),
        "available_fancy": humanize.naturalsize(ram.available, binary=True)
    }


@app.route("/ram/swap")
def vmem_usage():
    swap = psutil.swap_memory()
    return {
        "percent": swap.percent,
        "total": swap.total,
        "free": swap.free,
        "used": swap.used,
        "total_fancy": humanize.naturalsize(swap.total, binary=True),
        "free_fancy": humanize.naturalsize(swap.free, binary=True),
        "used_fancy": humanize.naturalsize(swap.used, binary=True)
    }


if hasattr(psutil, "sensors_temperatures"):
    @app.route("/sensors/coretemp")
    def temperature_sensor():
        sensors = psutil.sensors_temperatures()
        cpusense = sensors.get("coretemp", {})
        # Work out average
        temp = 0
        for t in cpusense:
            temp += t.current
        temp /= len(cpusense)
        return {
            "temperature": temp
        }

else:
    @app.route("/sensors/coretemp")
    def temperature_sensor():
        return {
            "error": "Not supported on this OS"
        }, 401

if __name__ == "__main__":
    app.run()
